/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.rsf;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.settings.acctinfo.AccountInfo;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rsf.RsfRequestBody;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;
import com.ibm.hwmca.xfw.rsf.RsfReportingMachineInfo;
import com.ibm.hwmca.xfw.rsf.RsfUpdateableComponentInfo;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class XFrameRsfRequestBody
extends RsfRequestBody {
    private static final String TRACE_MASKT = "XRSFXF T";
    private static final String TRACE_MASKF = "XRSFXF F";
    private static final String TRACE_MASKD = "XRSFXF D";
    protected Object attachment;
    protected RsfMachineInfo machineInfo;
    protected Collection currentUpdates;
    protected char functionId = (char)32;
    protected char functionUserid = (char)32;
    protected String requestType = null;
    protected int requestTypeVersion = 0;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$persist$Persistable;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$persist$PersistentData;

    public XFrameRsfRequestBody(PersistentData data) {
        super(((Persistent)data).parentData);
        this.machineInfo = ((Persistent)data).machineInfo;
        this.functionId = ((Persistent)data).functionId;
        this.functionUserid = ((Persistent)data).functionUserid;
        this.currentUpdates = ((Persistent)data).currentUpdates;
        if (((Persistent)data).attachment == null) {
            this.attachment = null;
        } else {
            try {
                this.attachment = PersistenceManager.getPersistenceManager().containedFormToObject(((Persistent)data).attachment);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Error reconstructing attachment within XFrameRsfRequestBody");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    public XFrameRsfRequestBody() {
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.machineInfo = this.machineInfo;
        result.functionId = this.functionId;
        result.functionUserid = this.functionUserid;
        result.currentUpdates = this.currentUpdates;
        if (this.attachment == null) {
            result.attachment = null;
        } else {
            try {
                result.attachment = PersistenceManager.getPersistenceManager().objectToContainedForm(this.attachment);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "XFrameRsfRequestBody.getPersistentData: Error constructing persistent data from attachment");
                Trace.trace(TRACE_MASKF, e);
            }
        }
        return result;
    }

    public boolean isUpgradeData() {
        return false;
    }

    public boolean isValid() {
        if (this.machineInfo == null) {
            this.invalidMessage = "No machine type, model and serial set";
            Trace.trace(TRACE_MASKF, "XFrameRsfRequestBody.isValid: " + this.invalidMessage);
            return false;
        }
        if (this.currentUpdates == null) {
            Trace.trace(TRACE_MASKF, "XFrameRsfRequestBody.isValid: No current updates");
        }
        return true;
    }

    public void initializeCustomerContactInformation() {
        AccountInfo acctInfo = BaseTower.getBaseTower().getAccountSettings();
        String data = acctInfo.getContact();
        if (data != null) {
            this.attributes.put("Customer contact", data);
        }
        if ((data = acctInfo.getVoiceNumber()) != null) {
            this.attributes.put("Customer voice number", data);
        }
        if ((data = acctInfo.getModemNumber()) != null) {
            this.attributes.put("Customer modem number", data);
        }
    }

    public void initializeMachineInformation() {
        try {
            this.machineInfo = RsfReportingMachineInfo.getLocalReportingMachineInfo();
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "XFrameRsfRequestBody.initializeMachineInformation: Error getting reporting machine data: ");
            Trace.trace(TRACE_MASKF, e);
        }
        this.consoleRequest = true;
    }

    public void initializeUpdateList() {
        this.currentUpdates = new ArrayList();
        List allUpdates = UpdateManager.getUpdateManager().getTowerUpdateableComponents();
        Iterator ucs = allUpdates.iterator();
        while (ucs.hasNext()) {
            this.currentUpdates.add(new RsfUpdateableComponentInfo((UpdateableComponent)ucs.next()));
        }
    }

    public void setUserAttachement(Object userAttachment) throws IllegalArgumentException {
        if (!(userAttachment == null || (class$java$io$Serializable == null ? (class$java$io$Serializable = XFrameRsfRequestBody.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(userAttachment.getClass()) || (class$com$ibm$hwmca$fw$persist$Persistable == null ? (class$com$ibm$hwmca$fw$persist$Persistable = XFrameRsfRequestBody.class$("com.ibm.hwmca.fw.persist.Persistable")) : class$com$ibm$hwmca$fw$persist$Persistable).isAssignableFrom(userAttachment.getClass()) || (class$com$ibm$hwmca$fw$persist$PersistentData == null ? (class$com$ibm$hwmca$fw$persist$PersistentData = XFrameRsfRequestBody.class$("com.ibm.hwmca.fw.persist.PersistentData")) : class$com$ibm$hwmca$fw$persist$PersistentData).isAssignableFrom(userAttachment.getClass()))) {
            String msg = "The body does not implement either java.io.Serializable, com.ibm.hwmca.fw.persist.Persistable, or com.ibm.hwmca.fw.persist.PersistentData";
            throw new IllegalArgumentException(msg);
        }
        this.attachment = userAttachment;
    }

    public Object getUserAttachment() {
        return this.attachment;
    }

    public void setReportingMachineInfo(RsfMachineInfo machineInfo) throws IllegalArgumentException {
        if (machineInfo == null) {
            throw new IllegalArgumentException();
        }
        this.machineInfo = machineInfo;
    }

    public RsfMachineInfo getReportingMachineInfo() {
        return this.machineInfo;
    }

    public void setConsoleRequest(boolean consoleRequest) {
        this.consoleRequest = consoleRequest;
    }

    public boolean isConsoleRequest() {
        return this.consoleRequest;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestTypeVersion(int version) {
        this.requestTypeVersion = version;
    }

    public int getRequestTypeVersion() {
        return this.requestTypeVersion;
    }

    public void setUpdateLevels(Collection currentUpdateLevels) throws IllegalArgumentException {
        if (currentUpdateLevels == null) {
            throw new IllegalArgumentException();
        }
        this.currentUpdates = currentUpdateLevels;
    }

    public Collection getUpdateLevels() {
        return this.currentUpdates;
    }

    private String buildUpdateXmlFormat(boolean toString) {
        StringBuffer buffer;
        block7: {
            if (this.currentUpdates == null || this.currentUpdates.isEmpty()) {
                return "";
            }
            buffer = new StringBuffer("<MCLLIST>");
            if (toString) {
                buffer.append('\n');
            }
            try {
                Iterator mcls = this.currentUpdates.iterator();
                while (mcls.hasNext()) {
                    if (toString) {
                        buffer.append(((RsfUpdateableComponentInfo)mcls.next()).toString());
                        continue;
                    }
                    buffer.append(((RsfUpdateableComponentInfo)mcls.next()).toXmlTransferFormat());
                }
            }
            catch (ClassCastException e) {
                Trace.trace(TRACE_MASKF, "List of Update levels contains a non-RsfUpdateableComponentInfo object");
                if (toString) break block7;
                throw e;
            }
        }
        buffer.append("</MCLLIST>");
        if (toString) {
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private String buildAttributeMapXmlFormat(boolean toString) {
        StringBuffer buffer;
        block7: {
            if (this.attributes == null || this.attributes.isEmpty()) {
                return "";
            }
            buffer = new StringBuffer("<AL>");
            if (toString) {
                buffer.append('\n');
            }
            try {
                Iterator values = this.attributes.keySet().iterator();
                while (values.hasNext()) {
                    String name = (String)values.next();
                    String value = (String)this.attributes.get(name);
                    if (toString) {
                        buffer.append("  ");
                    }
                    buffer.append("<AN>");
                    buffer.append(name);
                    buffer.append("</AN>");
                    buffer.append("<AV>");
                    buffer.append(value);
                    buffer.append("</AV>");
                    if (!toString) continue;
                    buffer.append('\n');
                }
            }
            catch (ClassCastException e) {
                Trace.trace(TRACE_MASKF, "Name or value in attribute map is not java.lang.String");
                if (toString) break block7;
                throw e;
            }
        }
        buffer.append("</AL>");
        if (toString) {
            buffer.append('\n');
        }
        return buffer.toString();
    }

    protected String buildFileListXmlFormat(Collection fileList, boolean toString) throws ClassCastException {
        StringBuffer buffer;
        block7: {
            if (fileList == null || fileList.isEmpty()) {
                return "";
            }
            buffer = new StringBuffer("<FILELIST>");
            if (toString) {
                buffer.append('\n');
            }
            try {
                Iterator files = fileList.iterator();
                while (files.hasNext()) {
                    File currentFile = (File)files.next();
                    if (toString) {
                        buffer.append("  ");
                    }
                    buffer.append("<FN>" + currentFile.getAbsolutePath() + "</FN>");
                    if (!toString) continue;
                    buffer.append('\n');
                }
            }
            catch (ClassCastException e) {
                Trace.trace(TRACE_MASKF, "List of files a non-File object");
                if (toString) break block7;
                throw e;
            }
        }
        buffer.append("</FILELIST>");
        if (toString) {
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public String toXmlTransferFormat() throws ClassCastException {
        StringBuffer buffer = new StringBuffer();
        if (this.machineInfo != null) {
            buffer.append(this.machineInfo.toXmlTransferFormat());
        }
        buffer.append(this.buildUpdateXmlFormat(false));
        buffer.append(this.buildAttributeMapXmlFormat(false));
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.machineInfo != null) {
            buffer.append(this.machineInfo.toString());
        }
        buffer.append(this.buildUpdateXmlFormat(true));
        buffer.append(this.buildAttributeMapXmlFormat(true));
        return buffer.toString();
    }

    protected String buildUseridAndFunction() {
        return "<FID>" + this.functionUserid + ":" + this.functionId + "</FID>";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        RsfMachineInfo machineInfo;
        Collection currentUpdates;
        Object attachment;
        char functionId;
        char functionUserid;
        int version = 0;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

